/**
 * \file: MediaBrowserChannel.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: K. Kuroda / ADITJ/SW / kkuroda@jp.adit-jv.com
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include <adit_logging.h>
#include "MediaBrowserChannel.h"
#include "DemoFactory.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

MediaBrowserChannel::MediaBrowserChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId)
 : mSessionId(inSessionId), mReceiver(inReceiver)
{
    mEndpoint = nullptr;
}

MediaBrowserChannel::~MediaBrowserChannel()
{
    LOGD_DEBUG((demo, "Media Browser Channel destructor"));
    mEndpoint = nullptr;
}

void MediaBrowserChannel::shutdown()
{
    if (mEndpoint != nullptr) {
        mEndpoint->shutdown();
    }
}

bool MediaBrowserChannel::Initialize()
{
    LOGD_DEBUG((demo, "new MediaBrowserEndpoint "));

    auto creator = DemoFactory::instance().getCreator<AditMediaBrowser, MediaBrowserCreatorFn>("DummyMediaBrowser");
    if (creator != nullptr)
    {
        mEndpoint = creator(mSessionId, mReceiver->messageRouter());
    }
    else
    {
        LOG_ERROR((demo, "failed to get creator object"));
        return false;
    }

    if(mEndpoint == nullptr)
    {
        LOG_ERROR((demo, "failed to get output of creator"));
        return false;
    }

    mEndpoint->registerCallbacks(this);

    if(!mEndpoint->init())
    {
        LOG_ERROR((demo, "failed to initialize media browser source endpoint"));
        return false;
    }
    // The argument of API is done const_cast because GalReceiver requires non const pointer.
    if(!mReceiver->registerService(const_cast<AditMediaBrowser*>(mEndpoint.get())))
    {
        LOG_ERROR((demo, "failed to register media browser source endpoint to receiver"));
        return false;
    }

    return true;
}

int MediaBrowserChannel::reportAction(const std::string& path, uint32_t action)
{
    int ret = -1;

    if(mEndpoint != nullptr)
    {
        ret = mEndpoint->reportAction(path, action);
    }
    else
    {
        LOG_ERROR((demo, "reportAction()  Media Browser endpoint is invalid"));
    }

    return ret;
}

int MediaBrowserChannel::mediaGetNode(const std::string& path, uint32_t start, bool get_album_art)
{
    int ret = -1;

    if(mEndpoint != nullptr)
    {
        ret = mEndpoint->mediaGetNode(path, start, get_album_art);
    }
    else
    {
        LOG_ERROR((demo, "mediaGetNode()  Media Browser endpoint is invalid"));
    }

    return ret;
}

void MediaBrowserChannel::rootNodeCallback(const struct MediaRootNodeStruct& node)
{
    LOGD_DEBUG((demo, "-- Media Browser root Node Callback -- path: %s", node.path.c_str()));
    for(uint32_t i = 0; i < node.num_sources; i++)
    {
        LOGD_DEBUG((demo, " Sources[%d](path): %s Name: %s", i, node.sources[i].path.c_str(), node.sources[i].name.c_str()));
    }
    LOGD_DEBUG((demo, " number of sources: %d", node.num_sources));

}

void MediaBrowserChannel::sourceNodeCallback(const struct MediaSourceNodeStruct& node)
{
    (void) node;
    LOGD_DEBUG((demo, "-- Media Browser source node callback --"));
}

void MediaBrowserChannel::listNodeCallback(const struct MediaListNodeStruct& node)
{
    (void) node;
    LOGD_DEBUG((demo, "-- Media Browser list node callback --"));
}

void MediaBrowserChannel::songNodeCallback(const struct MediaSongNodeStruct& node)
{
    (void) node;
    LOGD_DEBUG((demo, "-- Media Browser song node callback --"));
}

} } // namespace adit { namespace aauto
